<?php
/* --------------------------------------------------------------
  StoreProductOptionVpeData.php 2021-11-03
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2021 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Deprecated\Vpe\App\Actions;

use Exception;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Data\VpeRepository;
use Gambio\Core\Application\Http\AbstractAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * Class StoreProductOptionVpeData
 * @package    Gambio\Admin\Modules\Deprecated\Vpe\App\Actions
 * @deprecated will be removed with the release of 4.7!
 */
class StoreProductOptionVpeData extends AbstractAction
{
    /**
     * @var VpeRepository
     */
    private $repository;
    
    
    /**
     * @param VpeRepository $repository
     */
    public function __construct(VpeRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        try {
            foreach ($request->getParsedBody() as ['productOptionId' => $productOptionId, 'vpeId' => $vpeId, 'vpeValue' => $vpeValue]) {
                
                $this->repository->storeVpeData((int)$productOptionId, (int)$vpeId, (float)$vpeValue);
            }
            
            return $response->withStatus(200);
        } catch (Exception $exception) {
            
            return $response->withStatus(409)->withJson(['message' => $exception->getMessage()]);
        }
    }
}